/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import morph.avaritia.api.CompressorRecipe;
import morph.avaritia.init.AvaritiaModContent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class DefaultCompressorRecipe
implements CompressorRecipe {
    private final ResourceLocation id;
    private final ItemStack result;
    private final int cost;
    private final NonNullList<Ingredient> ingredients;

    public DefaultCompressorRecipe(ResourceLocation id, ItemStack result, int cost, NonNullList<Ingredient> ingredients) {
        this.id = id;
        this.result = result;
        this.cost = cost;
        this.ingredients = ingredients;
    }

    public boolean m_5818_(Container container, Level p_44003_) {
        if (container.m_6643_() != 1) {
            return false;
        }
        ItemStack slot = container.m_8020_(0);
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.test(slot)) continue;
            return true;
        }
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack m_5874_(Container p_44001_) {
        return this.m_8043_().m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AvaritiaModContent.DEFAULT_COMPRESSOR_RECIPE.get();
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<DefaultCompressorRecipe> {
        public DefaultCompressorRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int cost = GsonHelper.m_13927_((JsonObject)json, (String)"cost");
            NonNullList ingredients = ShapelessRecipe.Serializer.m_44275_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for DefaultCompressorRecipe.");
            }
            return new DefaultCompressorRecipe(id, result, cost, (NonNullList<Ingredient>)ingredients);
        }

        @Nullable
        public DefaultCompressorRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ItemStack result = buf.m_130267_();
            int cost = buf.m_130242_();
            int numIngredients = buf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)numIngredients, (Object)Ingredient.f_43901_);
            for (int i = 0; i < numIngredients; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            return new DefaultCompressorRecipe(id, result, cost, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buf, DefaultCompressorRecipe recipe) {
            buf.m_130055_(recipe.m_8043_());
            buf.m_130130_(recipe.getCost());
            buf.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buf);
            }
        }
    }
}

